import { ControlBase, MainControlProps, MainControlState } from '@ibiz-core';

/**
 * 实体部件
 * @export
 * @class ControlBase
 */
export class MainControl extends ControlBase {
  /**
   * 部件状态
   */
  public declare controlState: MainControlState;

  /**
   * 根据props调整设置部件state
   * @param props 传入的Props
   */
  public setState(props: MainControlProps) {
    super.setState(props);
    // 只读属性处理：把props的属性的Ref赋给state，以维持响应性。
    this.controlState.showBusyIndicator = toRef(props, 'showBusyIndicator') as any;
    this.controlState.controlAction = toRef(props, 'controlAction') as any;
  }

  /**
   * 安装部件所有功能模块的方法
   * @param props 传入的Props
   * @param [emit] 事件
   */
  public moduleInstall(props: MainControlProps, emit?: Function) {
    const superParams = super.moduleInstall(props, emit);
    return {
      ...superParams,
      state: this.controlState,
    };
  }
}
